#pragma once

#include <internal/message_tree.h>
#include <internal/content_transformers.h>
#include <internal/sanitizer.h>
#include <internal/sanitizer_tykva.h>
#include <message_body/text_transformer_result.h>
#include <internal/fact_extractor/async_fact_extractor.h>

namespace msg_body {

class Configuration;
class TransformerAttributes;
struct MessageContext;
struct ParserConfig;
class InlineSpoofer;

class TextTransformer {
public:
    TextTransformer(const Configuration& config,
        TransformerAttributes& attrs,
        MessageContext& messageContext,
        LogPtr logger,
        const IContentTypeDetector& contentTypeDetector,
        const AliasClassList& aliasClassList,
        unsigned trimThreshold_,
        VdirectPtr vdirect,
        const Sanitizer& sanitizer,
        const InlineSpoofer& inlineSpoofer,
        const Recognizer::Wrapper& recognizer,
        const TextAsyncFactExtractor& asyncFactExtractor);

    TextTransformerResult apply(MessagePart& part) const;

private:
    void transformTextContent(MessagePart& part, TextTransformerResult& res) const;
    bool checkForPhishing(const std::string& content, const std::string& stid) const;
    void checkNestedTags(MessagePart& part) const;

    const Configuration& config_;
    TransformerAttributes& attrs_;
    MessageContext& messageContext_;
    LogPtr logger_;
    const IContentTypeDetector& contentTypeDetector_;
    const AliasClassList& aliasClassList_;
    unsigned trimThreshold_;
    ContentTransformers contentTransformers_;
    const Sanitizer& sanitizer_;
    const InlineSpoofer& inlineSpoofer_;
    const Recognizer::Wrapper& recognizer;
    const TextAsyncFactExtractor& asyncFactExtractor_;
};

}
