#pragma once

#include <string>
#include <stdexcept>
#include <memory>

#include <internal/exceptions.h>
#include <internal/logger.h>
#include <internal/transformers/message_transformer.h>
#include <internal/transformers/pkpass_transformer.h>
#include <internal/transformers/calendar_transformer.h>
#include <internal/transformers/narod_transformer.h>
#include <internal/transformers/binary_transformer.h>
#include <internal/transformers/text_transformer.h>
#include <message_body/transformers_result.h>

namespace msg_body {

class TransformerAttributes;
struct MessagePart;
struct MessageTree;
struct MessageContext;
class Sanitizer;
class InlineSpoofer;

class Transformers {
public:
    Transformers(const Configuration& config,
        TransformerAttributes& attrs,
        MessageContext& messageContext,
        LogPtr logger,
        const IContentTypeDetector& contentTypeDetector,
        const AliasClassList& aliasClassList,
        unsigned trimThreshold,
        VdirectPtr vdirect,
        const Sanitizer& sanitizer,
        const InlineSpoofer& inlineSpoofer,
        const Recognizer::Wrapper& recognizer,
        const TextAsyncFactExtractor& asyncFactExtractor);
    TransformersResultPtr apply(MessagePart& part, const std::string& transformerType) const;

private:
    BinaryTransformerResultPtr applyBinaryTransformer(MessagePart& part) const;
    CalendarTransformerResultPtr applyCalendarTransformer(MessagePart& part) const;
    MessageTransformerResultPtr applyMessageTransformer(MessagePart& part) const;
    NarodTransformerResultPtr applyNarodTransformer(MessagePart& part) const;
    TextTransformerResultPtr applyTextTransformer(MessagePart& part) const;
    PassbookPackagePtr applyPkpassTransformer(MessagePart& part) const;

    TransformerAttributes& attrs_;
    MessageContext& messageContext_;
    LogPtr logger_;

    PkpassTransformer pkpassTransformer_;
    MessageTransformer messageTransformer_;
    CalendarTransformer calendarTransformer_;
    NarodTransformer narodTransformer_;
    BinaryTransformer binaryTransformer_;
    TextTransformer textTransformer_;
};

}
