/* Alexey Kuzyakov <alexbft@yandex-team.ru> 11.08.2008
 *
 * UUENCODE parser
 *
 */

#ifndef _UUDECODE_H_
#define _UUDECODE_H_

#include <message_body/uudecode_chunk.h>

namespace msg_body {

namespace uudecode {

    class ChunkWrapper {
    public:
        ChunkWrapper() {}

        /// creates chunk from string.
        /// Returns pointer to end of chunk if successful, 0 if failed.
        const char * create_from(const char *begin);

        void swap(ChunkWrapper& other) {
            std::swap(chunk_, other.chunk_);
        }

        Chunk chunk() const {
            return Chunk(chunk_);
        }

        void setMimeType();

    private:
        ChunkBase chunk_;

        const char * create_from_base64(const char *begin);
        const char * create_from_traditional(const char *begin);
        bool read_header(const char *&s); //parses first string "begin 644 filename.ext" (s points to the space after the word 'begin'). If successful, sets s to the next line of text and returns true, otherwise returns false.
        bool read_line_traditional(const char *&s, bool &is_end, int &last_line_length);
        bool read_line_base64(const char *&s, bool &is_end);
    };

    typedef std::vector<ChunkWrapper> ChunkWrappers;

    void GetUuencodeXMLRepresentation(std::string &pattern, ChunkWrappers& chunks);

} // namespace uudecode

} // namespace msg_body

#endif /* _UUDECODE_H_ */
