#pragma once

#include <boost/asio/spawn.hpp>
#include <yplatform/reactor.h>

namespace msg_body {

using YieldCtx = boost::asio::yield_context;

template <typename Handler>
void spawn(Handler&& handler, std::size_t coroutineStackSize) {
    const auto io = yplatform::global_net_reactor->io();
    boost::asio::spawn(
        *io,
        std::forward<Handler>(handler),
        boost::coroutines::attributes(coroutineStackSize)
    );
}

} // namespace msg_body
