#pragma once

#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-parameter"
#include <zipios++/zipinputstream.h>
#pragma clang diagnostic pop

namespace msg_body {

class ZipIterator;

class ZipEntry {
public:
    ZipEntry(zipios::ZipInputStream* stream = 0)
        : stream_(stream)
    {}

    std::string data() const {
        std::ostringstream ss;
        ss << stream_->rdbuf();
        return ss.str();
    }

    const zipios::ConstEntryPointer& header() const {
        return header_;
    }

    void reset() {
        stream_ = 0;
        header_ = 0;
    }

    bool operator==(const ZipEntry& other) const {
        return stream_ == other.stream_ && header_ == other.header_;
    }

private:
    friend class ZipIterator;

    zipios::ZipInputStream* stream_;
    zipios::ConstEntryPointer header_;
};

class ZipIterator {
public:
    typedef std::forward_iterator_tag iterator_category;
    typedef std::ptrdiff_t difference_type;
    typedef ZipEntry value_type;
    typedef value_type* pointer;
    typedef value_type& reference;
    typedef const value_type& const_reference;

    ZipIterator(zipios::ZipInputStream& zipStream )
        : zipEntry_(&zipStream)
    {
        peek();
    }

    ZipIterator()
    {}

    ZipIterator& operator++() {
        peek();
        return *this;
    }

    const_reference operator*() const {
        return zipEntry_;
    }

    pointer operator->() {
        return &zipEntry_;
    }

    bool operator==(const ZipIterator& rhs) const {
        return zipEntry_ == rhs.zipEntry_;
    }

    bool operator!=(const ZipIterator& rhs) const {
        return !(operator==(rhs));
    }

private:
    ZipEntry zipEntry_;

    void peek() {
        zipios::ConstEntryPointer entry = zipEntry_.stream_->getNextEntry();
        if (!entry.get() || !entry->isValid()) {
            zipEntry_.reset();
        } else {
            zipEntry_.header_ = entry;
        }
    }
};

}

