#ifndef BINARY_TRANSFORMER_RESULT_H_2014_01_15
#define BINARY_TRANSFORMER_RESULT_H_2014_01_15

#include <message_body/facts.h>
#include <message_body/ext_transformers_selector_result.h>
#include <message_body/part_type_info.h>

namespace msg_body {

struct BinaryTransformerResult {
    std::string hid;
    MimeType contentType;
    bool isInline;
    bool isStreamerOn;
    std::string cid;
    MessagePartTypeInfo typeInfo;
    FactsPtr facts;
    ExternalTransformersSelectorResult externalTransformersSelector;
};

typedef boost::shared_ptr<BinaryTransformerResult> BinaryTransformerResultPtr;

}

BOOST_FUSION_ADAPT_STRUCT(msg_body::BinaryTransformerResult,
    (std::string, hid)
    (MimeType, contentType)
    (bool, isInline)
    (bool, isStreamerOn)
    (std::string, cid)
    (msg_body::MessagePartTypeInfo, typeInfo)
    (msg_body::FactsPtr, facts)
    (msg_body::ExternalTransformersSelectorResult, externalTransformersSelector)
)

#endif // BINARY_TRANSFORMER_RESULT_H_2014_01_15
