#ifndef DARIA_REFLECTION_H
#define DARIA_REFLECTION_H

#include <yamail/data/reflection/reflection.h>
#include <message_body/transformers_result.h>
#include <message_body/dkim.h>

namespace msg_body {

struct DariaBodyResult {
    bool isAttach;
    std::string hid;
    TransformersResultPtr transformerResult;
};

typedef std::vector<DariaBodyResult> DariaBodiesResult;

struct DariaDateResult {
    size_t timestamp;
    size_t userTimestamp;
};

struct DariaAddressResult {
    std::string direction;
    std::string name;
    std::string email;
};

typedef std::vector<DariaAddressResult> DariaAddressesResult;

struct DariaNoReplyResult {
    std::string notification;
};

struct DariaInfoResult {
    std::string stid;
    std::string references;
    std::string inReplyTo;
    std::string messageId;
    std::string filterId;
    std::string personalSpam;
    std::string spam;
    std::string deliveredTo;
    std::string listUnsubscribe;
    std::string flightDirection;
    std::string liveMail;
    DariaDateResult dateResult;
    DariaAddressesResult addressesResult;
    DariaNoReplyResult noReplyResult;
    Dkim dkim;
    std::string senderDomain;
    std::string signedBy;
    std::string dkimStatus;
    bool encrypted;
    bool isSpam;
    std::string collectedRpopId;
};

struct DariaResult {
    DariaBodiesResult bodies;
    TransformPartsResult attachments;
    TransformPartsResult signatures;
    TransformPartsResult calendars;
    TransformPartsResult passbooks;
    DariaInfoResult info;
};

}

BOOST_FUSION_ADAPT_STRUCT(msg_body::DariaBodyResult,
    (bool, isAttach)
    (std::string, hid)
    (msg_body::TransformersResultPtr, transformerResult)
)

BOOST_FUSION_ADAPT_STRUCT(msg_body::DariaDateResult,
    (size_t, timestamp)
    (size_t, userTimestamp)
)

BOOST_FUSION_ADAPT_STRUCT(msg_body::DariaAddressResult,
    (std::string, direction)
    (std::string, name)
    (std::string, email)
)

BOOST_FUSION_ADAPT_STRUCT(msg_body::DariaNoReplyResult,
    (std::string, notification)
)

BOOST_FUSION_ADAPT_STRUCT(msg_body::DariaInfoResult,
    (std::string, stid)
    (std::string, references)
    (std::string, inReplyTo)
    (std::string, messageId)
    (std::string, filterId)
    (std::string, personalSpam)
    (std::string, spam)
    (std::string, deliveredTo)
    (std::string, listUnsubscribe)
    (std::string, flightDirection)
    (std::string, liveMail)
    (std::string, senderDomain)
    (std::string, signedBy)
    (std::string, dkimStatus)
    (std::string, collectedRpopId)
    (bool, encrypted)
    (bool, isSpam)
    (msg_body::DariaDateResult, dateResult)
    (msg_body::DariaAddressesResult, addressesResult)
    (msg_body::DariaNoReplyResult, noReplyResult)
    (msg_body::Dkim, dkim)
)

BOOST_FUSION_ADAPT_STRUCT(msg_body::DariaResult,
    (msg_body::DariaBodiesResult, bodies)
    (msg_body::TransformPartsResult, attachments)
    (msg_body::TransformPartsResult, signatures)
    (msg_body::TransformPartsResult, calendars)
    (msg_body::TransformPartsResult, passbooks)
    (msg_body::DariaInfoResult, info)
)

#endif // DARIA_REFLECTION_H
