#ifndef DKIM_H_2014_02_21
#define DKIM_H_2014_02_21

#include <yamail/data/reflection/reflection.h>
#include <message_body/reflection_common.h>

namespace msg_body {

class Dkim {
public:
    enum Status {
        unknown = 0,
        valid,
        nosig,
        badsig
    };

    Dkim(Status status = unknown, const std::string& headeri = "" )
        : status_(status)
        , headeri_(headeri)
    {}

    std::string domain() const {
        const std::size_t domainPos = headeri_.find('@');
        return headeri_.substr(domainPos!=std::string::npos ? domainPos + 1 : 0);
    }

    std::string statusString() const {
        switch (status_) {
        case valid:
            return "OK";
        case nosig:
            return "NOSIG";
        case badsig:
            return "BADSIG";
        case unknown:
        default:
            return "UNKNOWN";
        }

    }

    bool succeeded() const {
        return status_ == valid;
    }

    int status() const {
        return status_;
    }

    void setStatus(const int& status) {
        status_ = static_cast<Status>(status);
    }

    const std::string& headeri() const {
        return headeri_;
    }

    void setHeaderi(const std::string& headeri) {
        headeri_ = headeri;
    }

private:
    Status status_;
    std::string headeri_;
};

}

YREFLECTION_ADAPT_ADT(msg_body::Dkim,
    (status, int, int, obj.status(), obj.setStatus(val))
    (headeri, std::string, std::string, obj.headeri(), obj.setHeaderi(val))
)

#endif // DKIM_H_2014_02_21
