#ifndef EMBED_INFO_H_2013_11_21
#define EMBED_INFO_H_2013_11_21

#include <string>
#include <vector>
#include <yamail/data/reflection/reflection.h>

namespace msg_body {

struct EmbedInfo {
    int id;
    std::string player_url;
    std::string flashvars;
    int height;
    int width;
    std::string original_url;
    std::string hosting_name;
};

typedef std::vector<EmbedInfo> EmbedInfos;

}

BOOST_FUSION_ADAPT_STRUCT(msg_body::EmbedInfo,
    (int, id)
    (std::string, player_url)
    (std::string, flashvars)
    (int, height)
    (int, width)
    (std::string, original_url)
    (std::string, hosting_name)
)

#endif // EMBED_INFO_H_2013_11_21
