#pragma once

#include <string>
#include <set>
#include <optional>
#include <butil/tvm_ticket.h>
#include <internal/sanitizer_tykva.h>

namespace msg_body {

struct MessageBodyParams {
    std::string hid;
    tvm::Ticket ticket;
    std::string timeZone;
    std::string charset;
    std::string to;
    std::string mid;
    std::string lang;
    std::string flags;
    std::set<int> types;
    std::string authDomain;
    std::string userDomain;
    bool isSecure = true;
    bool isSpam = false;

    std::string connectionId;
    std::string requestId;
    std::string remoteIp;
    std::string yandexUidCookie;
    std::string iCookie;
    std::string clientType;
    std::string clientVersion;
    std::string userAgent;
    std::string testBuckets;
    std::string enabledTestBuckets;
    sanitizer::Strategy sanitizerStrategy;
    std::optional<std::string> system;
};

} // namespace msg_body
