#ifndef NAROD_TRANSFORMER_RESULT_H_2014_01_15
#define NAROD_TRANSFORMER_RESULT_H_2014_01_15

#include <vector>
#include <message_body/part_class_info.h>

namespace msg_body {

struct TransformNarodAttachResult {
    std::string fakeHid;
    std::string url;
    std::string hash;
    std::string name;
    PartClassInfo partClassInfo;
    bool isFolder;
    std::string sizeDescription;
    std::string preview;
};

typedef std::unique_ptr<TransformNarodAttachResult> TransformNarodAttachResultPtr;
typedef std::vector<TransformNarodAttachResult> NarodTransformerResult;
typedef boost::shared_ptr<NarodTransformerResult> NarodTransformerResultPtr;

}

BOOST_FUSION_ADAPT_STRUCT(msg_body::TransformNarodAttachResult,
    (std::string, fakeHid)
    (std::string, url)
    (std::string, hash)
    (std::string, name)
    (msg_body::PartClassInfo, partClassInfo)
    (bool, isFolder)
    (std::string, sizeDescription)
    (std::string, preview)
)


#endif // NAROD_TRANSFORMER_RESULT_H_2014_01_15
