#ifndef PART_CLASS_INFO_H_2014_01_14
#define PART_CLASS_INFO_H_2014_01_14

#include <boost/filesystem.hpp>
#include <yamail/data/reflection/reflection.h>
#include <mail_getter/content_type.h>
#include <mail_getter/alias_class_list.h>

namespace msg_body {

struct PartClassInfo {
    std::string partClass_;
    bool isPreviewSupported_;
    bool doesBrowserSupport_;
};

inline PartClassInfo determinePartClass(const IContentTypeDetector& detector, const AliasClassList& mimeTypesList,
                                        const std::string& filename, const std::string& type, const std::string& subtype)
{
    MimeType mimeType(type, subtype);
    if (mimeType.isDefaultMimeType()) {
        mimeType = detector.detectByFilename(filename);
    }
    const std::string extension = boost::filesystem::path(filename).extension().string();
    const std::string alias = mimeTypesList.getAlias(extension, mimeType);

    const PartClassInfo res = {alias, mimeTypesList.canBeThumbnailed(mimeType), mimeTypesList.canBeBrowsed(mimeType)};
    return res;
}

}

BOOST_FUSION_ADAPT_STRUCT(msg_body::PartClassInfo,
    (std::string, partClass_)
    (bool, isPreviewSupported_)
    (bool, doesBrowserSupport_)
)

#endif // PART_CLASS_INFO_H_2014_01_14
