#ifndef MESSAGE_PART_INFO_H_2014_01_14
#define MESSAGE_PART_INFO_H_2014_01_14

#include <mail_getter/yplatform/mime_type_reflection.h>
#include <message_body/part_class_info.h>

namespace msg_body {

struct MessagePartTypeInfo {
    MimeType contentType;
    std::string name;
    std::string nameUriEncoded;
    std::string fileName;
    std::string fileExtension;
    std::string dispositionValue;
    std::string contentId;
    std::string contentLocation;
    std::string dispositionFilename;
    PartClassInfo partClassInfo;
    unsigned length;
};

}

BOOST_FUSION_ADAPT_STRUCT(msg_body::MessagePartTypeInfo,
    (MimeType, contentType)
    (std::string, name)
    (std::string, nameUriEncoded)
    (std::string, fileName)
    (std::string, fileExtension)
    (std::string, dispositionValue)
    (std::string, contentId)
    (std::string, contentLocation)
    (std::string, dispositionFilename)
    (msg_body::PartClassInfo, partClassInfo)
    (unsigned, length)
)

#endif // MESSAGE_PART_INFO_H_2014_01_14
