#pragma once

#include <mail_getter/recognizerWrapper.h>
#include <message_body/facts.h>
#include <message_body/part_type_info.h>
#include <message_body/content_transformers_result.h>

namespace msg_body {

struct TextTransformerResult {
    std::string hid;
    bool isMain = false;
    MessagePartTypeInfo typeInfo;
    bool isRaw = false;
    std::string content;
    bool divLimitExceeded = false;
    std::string lang;
    bool isTrimmed = false;
    ContentTransformersResult contentTransformersResult;
    FactsPtr facts;
    bool afterTykva = false;
};

typedef boost::shared_ptr<TextTransformerResult> TextTransformerResultPtr;

}

BOOST_FUSION_ADAPT_STRUCT(msg_body::TextTransformerResult,
    (std::string, hid)
    (bool, isMain)
    (msg_body::MessagePartTypeInfo, typeInfo)
    (bool, isRaw)
    (std::string, content)
    (std::string, lang)
    (bool, isTrimmed)
    (bool, divLimitExceeded)
    (msg_body::ContentTransformersResult, contentTransformersResult)
    (msg_body::FactsPtr, facts)
    (bool, afterTykva)
)

