#ifndef TRANSFORMERS_RESULT_H_2014_01_15
#define TRANSFORMERS_RESULT_H_2014_01_15

#include <message_body/binary_transformer_result.h>
#include <message_body/calendar_transformer_result.h>
#include <message_body/message_transformer_result.h>
#include <message_body/narod_transformer_result.h>
#include <message_body/text_transformer_result.h>
#include <message_body/passbook.h>

namespace msg_body {

struct TransformersResult {
    BinaryTransformerResultPtr binaryTransformerResult;
    CalendarTransformerResultPtr calendarTransformerResult;
    MessageTransformerResultPtr messageTransformerResult;
    NarodTransformerResultPtr narodTransformerResult;
    TextTransformerResultPtr textTransformerResult;
    PassbookPackagePtr pkpassTransformerResult;
};

typedef boost::shared_ptr<TransformersResult> TransformersResultPtr;
typedef std::vector<TransformersResultPtr> TransformPartsResult;

}

BOOST_FUSION_ADAPT_STRUCT(msg_body::TransformersResult,
    (msg_body::BinaryTransformerResultPtr, binaryTransformerResult)
    (msg_body::CalendarTransformerResultPtr, calendarTransformerResult)
    (msg_body::MessageTransformerResultPtr, messageTransformerResult)
    (msg_body::NarodTransformerResultPtr, narodTransformerResult)
    (msg_body::TextTransformerResultPtr, textTransformerResult)
    (msg_body::PassbookPackagePtr, pkpassTransformerResult)
)

#endif // TRANSFORMERS_RESULT_H_2014_01_15
