#ifndef UUDECODE_CHUNK_H_2014_01_15
#define UUDECODE_CHUNK_H_2014_01_15

#include <string>
#include <vector>
#include <yamail/data/reflection/reflection.h>
#include <message_body/reflection_common.h>

namespace msg_body {

namespace uudecode {

struct ChunkBase {
    std::string file_name;
    std::string mime_type;
    std::string m_content;
};

struct Chunk {
    std::string file_name;
    std::string mime_type;
    size_t size;

    Chunk()
    {}

    Chunk(const ChunkBase& cb)
        : file_name(cb.file_name)
        , mime_type(cb.mime_type)
        , size(cb.m_content.size())
    {}
};

typedef std::vector<Chunk> Chunks;

} // namespace uudecode

} // namespace msg_body

BOOST_FUSION_ADAPT_STRUCT(msg_body::uudecode::Chunk,
    (std::string, file_name)
    (std::string, mime_type)
    (size_t, size)
)


#endif // UUDECODE_CHUNK_H_2014_01_15
