package main

import (
	"net/http"
	"strings"
	"time"
)

type Ammo struct {
	Tag   string
	UID   string
	Mid   string
	Stid  string
	Flags string
}

func makeTimestamp() string {
	return time.Now().Format("15:04:05.000000")
}

func (g *Gun) makeReq(ammo *Ammo) *http.Request {
	req, _ := http.NewRequest("GET", strings.Join([]string{"http://", g.conf.Target, "/message?flags=", ammo.Flags, "&mid=", ammo.Mid, "&stid=", ammo.Stid, "&auth_domain=yandex.ru&secure=1&tz=Europe%2FMoscow&uid=", ammo.UID, "&user_domain=&connection_id="}, ""), nil)
	req.Header.Add("Content-Type", "application/x-www-form-urlencoded")
	req.Header.Add("Connection", "keep-alive")
	req.Header.Add("X-Real-IP", "213.180.206.57")
	req.Header.Add("X-Https-Request", "yes")
	req.Header.Add("User-Agent", "pandora")
	req.Header.Add("X-Request-Id", makeTimestamp()+"_"+ammo.UID)
	return req
}
