import sys
import random
import json
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--profile", type=str, help="string with json profile, in handler:weight format", default='{"mail-without-attaches": 1}')
parser.add_argument("--src", type=str, help="data source with ids from db", default='load/files/ammo.csv')
args = parser.parse_args()

def weighted_json_choice(choices):
   '''dict where key is choice and value probability'''
   total = sum(choices[choice] for choice in choices)
   r = random.uniform(0, total)
   upto = 0
   for choice in choices:
      if upto + choices[choice] >= r:
         return choice
      upto += choices[choice]


class Ammo(object):
    def __init__(self):
        self.output = []
        self.meta = self.meta_parser(args.src)
        #flag destribution from mbody log, if you read this refresh it
        self.flags = {
            "XmlStreamerOn%2CShowContentMeta": 31095,
            "XmlStreamerOn%2CShowContentMeta%2CSequentialFactex": 882,
            "XmlStreamerOn%2CXmlStreamerMobile%2CShowContentMeta": 498,
            "XmlStreamerOn%2CXmlStreamerMobile%2CShowContentMeta%2CNoVdirectLinksWrap": 7525
        }
        self.distr = self.set_distr_from_json(args.profile)

    def meta_parser(self, filename):
	out = {}
        with open(filename, "r") as fd:
            for line in fd:
                uid, mid, stid, size, t = line.rstrip().split(',')
                if t not in out:
                    out[t] = []
                out[t].append((uid,mid,stid,size))
        return out

    def set_distr_from_json(self, input_json):
        profile = json.loads(input_json.replace(" ", "").replace("\n", ""))
        out = []
        for i in xrange(40000):
            out.append(weighted_json_choice(profile))
        return out

    def make_ammo(self):
	counter = {
            "mail-with-inline-attach": 0,
            "mail-with-noninline-attach": 0,
            "mail-without-attaches": 0,
            "mail-with-calendar-and-narod": 0,
            "large-mail-with-attach": 0,
            "large-mail-with-seven-different-attaches": 0
        }
        with open("ammo.json", "w") as fd:
            for tag in self.distr:
                uid,mid,stid,size = self.meta[tag][counter[tag] % len(self.meta[tag])]
                out = '{"tag": "' + str(tag) + '", "uid": "' + str(uid)+ '", "mid": "' + str(mid) + '", "stid": "' + str(stid) + '", "flag": "' + weighted_json_choice(self.flags) + '"}'
                fd.write(out + "\n")
                counter[tag] += 1

if __name__ == "__main__":
    ammo = Ammo()
    ammo.make_ammo()
