#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wsign-conversion"
#endif

#include <yplatform/module_registration.h>

#ifdef __clang__
#pragma clang diagnostic pop
#endif

#include <internal/server/server.h>
#include <internal/module.h>

namespace msg_body {

MessageBodyModule::MessageBodyModule()
    : logger_(std::make_shared<ContextLogger>(makeLoggerWithRequestId("")))
{}

void MessageBodyModule::init(const yplatform::ptree& cfg) {
    config_.load(cfg, yplatform::find<ymod_tvm::tvm2_module, std::shared_ptr>("ymod_tvm"));
    bindServerHandles(config_);
    bindConfigChangeHandler(config_);

    MBODY_LOG_INFO(logger_, log::module=*config_.tvmGuard);
    MBODY_LOG_INFO(logger_, log::message="message_body module initialized");
}

void MessageBodyModule::reload(const yplatform::ptree&) {
    MBODY_LOG_INFO(logger_, log::message="message_body module reloaded");
}

void MessageBodyModule::start() {
    MBODY_LOG_INFO(logger_, log::message="message_body module started");
}

void MessageBodyModule::stop() {
    MBODY_LOG_INFO(logger_, log::message="message_body module stopped");
}

void MessageBodyModule::fini() {
    MBODY_LOG_INFO(logger_, log::message="message_body module finished");
}

}

DEFINE_SERVICE_OBJECT(msg_body::MessageBodyModule)
