#!/bin/bash

export app=mbody

source /app/init/service_sh/map_resources_qloud.sh
source /app/init/service_sh/environment_type_qloud.sh
source /app/init/service_sh/attach_sid_qloud.sh
source /app/init/service_sh/ephemerial_qloud.sh
source /app/init/service_sh/push_client_to_ephemerial_qloud.sh push-client-service
source /app/init/service_sh/postgres_qloud.sh
source /app/init/service_sh/tvm_qloud.sh
source /app/init/service_sh/tzdata_qloud.sh
source /app/init/service_sh/recognizer_qloud.sh
source /app/init/service_sh/ssl_qloud.sh
source /app/init/service_sh/link_push_client_qloud.sh
source /app/init/service_sh/vdirectkeys_qloud.sh

source /app/init/service_sh/application_links_to_config_and_tvm_root_id.sh
source /app/init/service_sh/unistat_dir.sh
source /app/init/service_sh/link_nginx_config.sh
source /app/init/service_sh/nginx_dirs_and_services.sh

set -ex

# make 10 attemps in case of any problems
for i in {1..10}; do
    if [[ -d /secrets/ssl ]]; then
        echo "copying crt"
        case "$ENVIRONMENT" in
            production)
                cp -f /secrets/ssl/mbody.mail.yandex.net.pem /app/secrets/ssl_cert.pem
                ;;
            intranet-production|corp)
                cp -f /secrets/ssl/mbodycorp.mail.yandex.net.pem /app/secrets/ssl_cert.pem
                ;;
            testing|load|prestable|intranet-prestable|corp-prestable)
                cp -f /secrets/ssl/star.mail.yandex.net.pem /app/secrets/ssl_cert.pem
                ;;
            *)
                echo "Unknown environment type: $ENVIRONMENT, cannot start"
                exit 1
                ;;
        esac

        if [[ "$?" != 0 ]]; then
            continue
        fi

        echo "ok"
        break
    else
        echo "No crt, sleeping"
        sleep 5
    fi
done

if [[ "$i" -eq 10 ]]; then
    echo "Cannot start"
    exit 1
fi

/usr/bin/supervisord -nc /etc/supervisor/supervisord.conf
