
#include <sstream>
#include <fstream>
#include <vector>
#include <iterator>
#include <algorithm>

#include <internal/external_transformers_selector.h>

namespace msg_body {

std::unique_ptr<ExternalTransformersSelector> ExternalTransformersSelector::instance_;

void ExternalTransformersSelector::init(const std::string& filename){
    ExternalTransformersSelector::instance_.reset(new ExternalTransformersSelector(filename));
}

bool ExternalTransformersSelector::by_ct(const std::string& ct_, std::string& transformer, std::string& filetype) const{
    std::string ct(ct_);
    std::transform(ct.begin(),ct.end(),ct.begin(),::toupper);
    TransformersMap::const_iterator it = external_transformers_ct.find(ct);
    if (it != external_transformers_ct.end()){
        transformer = it->second.first;
        filetype = it->second.second;
    }
    return (it != external_transformers_ct.end());
}

bool ExternalTransformersSelector::by_ext(const std::string& ext_, std::string& transformer, std::string& filetype) const{
    std::string ext(ext_);
std::transform(ext.begin(),ext.end(),ext.begin(),::toupper);
    TransformersMap::const_iterator it = external_transformers_ext.find(ext);
    if (it != external_transformers_ext.end()){
        transformer = it->second.first;
        filetype = it->second.second;
    }
    return (it != external_transformers_ext.end());
}

ExternalTransformersSelector::ExternalTransformersSelector(const std::string& filename){
    std::ifstream file(filename.c_str());
    std::string line;
    while (file.good()){
        std::vector<std::string> data;

        std::getline(file, line);
        std::stringstream stream(line);

        std::copy(std::istream_iterator<std::string>(stream), std::istream_iterator<std::string>(), std::back_inserter(data));
        if (data.size() == 4 && data[0][0] != '#'){
    std::transform(data[1].begin(),data[1].end(),data[1].begin(),::toupper);
            if (data[0] == "ext")
                external_transformers_ext[data[1]] = std::make_pair(data[2], data[3]);
            else if (data[0] == "ct")
                external_transformers_ct[data[1]] = std::make_pair(data[2], data[3]);
        }
    }
}

bool ExternalTransformersSelector::getTransformerAndFiletype(const MimeType& mType,
        const std::string& ext, std::string& transformer, std::string& filetype)
{
    return Instance()->by_ct(mType.toString(), transformer, filetype)
            || Instance()->by_ext(ext, transformer, filetype);
}

ExternalTransformersSelectorResult ExternalTransformersSelector::addExternalTransformersInfo(
    const std::string& filename, const std::string& type, const std::string& subtype)
{
    ExternalTransformersSelectorResult res;
    std::string ext=filename;
    std::string::size_type dot=ext.rfind('.');
    if (dot!=std::string::npos) ext=ext.substr(dot+1);
    MimeType mType (type, subtype);
    getTransformerAndFiletype(mType, ext, res.transformer, res.filetype);
    return res;
}

}
