#include <internal/fact_extractor/parser_config.h>
#include <internal/fact_extractor/xml_parser.h>

namespace msg_body {

ParserConfig createParserConfig(const std::string& path, LogPtr logger) {
    try {
        ParserConfig config;
        if (!path.empty()) {
            const xml::GetTypeMsgs getTypeMsgs = xml::GetTypeMsgs();
            const xml::ConvertTypeMsg convertTypeMsg = xml::ConvertTypeMsg();
            xml::Tree configData;
            boost::property_tree::read_xml(path, configData,
                    boost::property_tree::xml_parser::no_comments);

            xml::GetTypeMsgs::result_type xmlTypeMsgs = getTypeMsgs(configData);
            std::transform(xmlTypeMsgs.begin(), xmlTypeMsgs.end(),
                    std::back_inserter(config.rules), convertTypeMsg);
        } else {
            MBODY_LOG_WARN(logger, log::message="factextractor config path is empty");
        }
        return config;
    } catch (const std::bad_alloc&) {
        throw;
    } catch (const std::exception & e) {
        throw std::runtime_error(std::string("error loading fact extractor parser config: ") + e.what());
    }

}

}
