#include <butil/StrUtils/ToLower.h>
#include <internal/headers_parser.h>

namespace  msg_body {

HeaderParser::HeaderParser(MessageHeaders& _ma, const std::string& buf)
        :mulca_mime::header(buf), ma(_ma)
{
}

bool HeaderParser::handle_field(const std::string& name, const std::string::size_type beg,
        const std::string::size_type end)
{
    std::string lcname(name.size(), ' ');
    ToLower lowercase;
    std::transform(name.begin(), name.end(), lcname.begin(), lowercase);
    ma[lcname].emplace_back(buffer.substr(beg, end-beg));
    return true;
}

}