#include <cctype>

#include <internal/hilight/hilight.h>

namespace hiliter {
    namespace {

        bool isNBSP(const string& src, size_t pos) {
            const unsigned char NBSP1 = 0xC2;
            const unsigned char NBSP2 = 0xA0;
            return (pos + 1 < src.size()
                    && static_cast<unsigned char>(src[pos]) == NBSP1
                    && static_cast<unsigned char>(src[pos+1]) == NBSP2)
                || (pos > 0
                    && static_cast<unsigned char>(src[pos-1]) == NBSP1
                    && static_cast<unsigned char>(src[pos]) == NBSP2);
        }

         struct start: public state {
            start(hiliter::driver& drv): state(drv) {}
            void run(const string& src, size_t pos) override;
        };



        struct login: public state {
            login(hiliter::driver& drv, int b): state(drv), begin(b) {}
            void run(const string& src, size_t pos) override;

        private:
            int begin;
        };


        struct search_domain: public state {
            search_domain(hiliter::driver& drv, int b): state(drv), begin(b) {}
            void run(const string& src, size_t pos) override;

        private:
            int begin;
        };



        struct domain: public state {
            domain(hiliter::driver& drv, int b)
                : state(drv), begin(b), dotpos(0) {}
            void run(const string& src, size_t pos) override;
            static bool forbidden(const string& src, size_t pos);

        private:
            int begin, dotpos;
        };

        bool domain::forbidden(const string& src, size_t pos) {
            return (pos + 3 < src.size()
                    && src[pos] == '&'
                    && (src[pos + 1] == 'g' || src[pos + 1] == 'G')
                    && (src[pos + 2] == 't' || src[pos + 2] == 'T')
                    && src[pos + 3] == ';')
                || (pos + 3 < src.size()
                    && src[pos] == '&'
                    && (src[pos + 1] == 'l' || src[pos + 1] == 'L')
                    && (src[pos + 2] == 't' || src[pos + 2] == 'T')
                    && src[pos + 3] == ';')
                || (pos + 4 < src.size()
                    && src[pos] == '&'
                    && (src[pos + 1] == 'a' || src[pos + 1] == 'A')
                    && (src[pos + 2] == 'm' || src[pos + 2] == 'M')
                    && (src[pos + 3] == 'p' || src[pos + 3] == 'P')
                    && src[pos + 4] == ';')
                || (pos + 5 < src.size()
                    && src[pos] == '&'
                    && (src[pos + 1] == 'n' || src[pos + 1] == 'N')
                    && (src[pos + 2] == 'b' || src[pos + 2] == 'B')
                    && (src[pos + 3] == 's' || src[pos + 3] == 'S')
                    && (src[pos + 4] == 'p' || src[pos + 4] == 'P')
                    && src[pos + 5] == ';')
                || (pos + 7 < src.size()
                    && src[pos] == '&'
                    && src[pos + 1] == '#'
                    && src[pos + 2] == 'x'
                    && std::all_of(&src[pos + 3], &src[pos + 6], [](unsigned char c) { return std::isxdigit(static_cast<int>(c)); })
                    && src[pos + 7] == ';')
                || (src[pos] >= 0 && src[pos] <= 32)|| src[pos] == '\"' || src[pos] == '<'
                || src[pos] == '>' || src[pos] == '\\' || src[pos] == '^'
                || src[pos] == '`' || src[pos] == '{' || src[pos] == '|'
                || src[pos] == '}';
        }


        bool atomchar(char c) {
            return !((c > 0  && c <= ' ') || c == '(' || c=='"' || c ==')'
                     || c == ',' || c == '.' || c == ':' || c == ';' || c == '<'
                     || c == '>' || c == '[' || c == ']' || c == '@'
                     || c == '/' || c == '?' || c == '!');
        }



        void start::run(const string& src, size_t pos) {
            if((atomchar(src[pos]) && !isNBSP(src, pos)) || src[pos] == '.')
                set<login>(static_cast<int>(pos));
        }



        void login::run(const string& src, size_t pos) {
            if(src[pos] == '@') set<search_domain>(begin);
            else if((!atomchar(src[pos]) && src[pos] != '.') || isNBSP(src, pos)) set<start>();
        }



        void search_domain::run(const string& src, size_t pos) {
            if((atomchar(src[pos]) && !isNBSP(src, pos)) || src[pos] == '.') set<domain>(begin);
            else if(src[pos] != ' ' && src[pos] != '\t') set<start>();
        }



        void domain::run(const string& src, size_t pos) {
            if (pos < src.size() && src[pos] == '.') {
                if(!dotpos && !(src[pos-1]=='.' || (pos+1 < src.size() && src[pos+1]=='.'))) {
                    dotpos = static_cast<int>(pos);
                }
            } else if(pos >= src.size() || forbidden(src, pos) || !atomchar(src[pos]) || isNBSP(src, pos)) {
                if(dotpos && static_cast<int>(pos) - dotpos >= 3) {
                    while(src[pos - 1] == '.') --pos;
                    push(begin, static_cast<int>(pos));
                }
                set<start>();
            }
        }
   }

    namespace email {
        driver::driver(list<overlay>& r)
            : hiliter::driver(1, "<span class=\"wmi-mailto\">", "</span>", r) {
            set(new start(*this));
        }
    }
}
