#include <cctype>

#include <boost/lexical_cast.hpp>
#include <internal/hilight/hilight.h>
#include <internal/ext_video.h>

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wsign-conversion"
#endif

namespace hiliter {
    namespace {
        struct start: public state {
            start(hiliter::driver& d, msg_body::EmbedInfos* el, const Params& params, bool is)
                : state(d), elist(el), params(params), inSrc(is)
            {}
            void run(const string& src, size_t pos) override;

        private:
            msg_body::EmbedInfos* elist;
            const Params& params;
            bool inSrc;
        };



        struct skip: public state {
            skip(driver& d, int b, int c, msg_body::EmbedInfos* el, const Params& params, bool is)
                : state(d), begin(b), count(c), elist(el), params(params), inSrc(is)
            {}
            void run(const string& src, size_t pos) override;

        private:
            int begin, count;
            msg_body::EmbedInfos* elist;
            const Params& params;
            bool inSrc;
        };

        struct skipSrc: public state {
            skipSrc(driver& d, int c, msg_body::EmbedInfos* el, const Params& params)
                : state(d), count(c), elist(el), params(params)
            {}
            void run(const string& src, size_t pos) override;

        private:
            int count;
            msg_body::EmbedInfos* elist;
            const Params& params;
        };


        struct check: public state {
            check(driver& d, int b, msg_body::EmbedInfos* el, const Params& params, bool is)
                : state(d), begin(b), dotpos(0), elist(el), params(params), inSrc(is)
            {
                count[0] = count[1] = 0;
            }
            static bool forbidden(const string& src, size_t pos);
            static bool punctuation(char c);
            static bool amp(const string& str, int pos);
            bool in_parens(const string& src, size_t pos, int index);
            void run(const string& src, size_t pos) override;

        private:
            int begin, dotpos;
            int count[2];
            msg_body::EmbedInfos* elist;
            const Params& params;
            bool inSrc;
        };



        void start::run(const string& src, size_t pos) {
            if( extractMode() && !inSrc && pos + 4 < src.size()
                && (src[pos] == 's' || src[pos] == 'S')
                && (src[pos + 1] == 'r' || src[pos + 1] == 'R')
                && (src[pos + 2] == 'c' || src[pos + 2] == 'C')
            && src[pos + 3] == '='
            && (src[pos + 4] == '"' || src[pos + 4] == '\'') ) {

        set<skipSrc>(4, elist, params);
            }
            else if(pos + 6 < src.size()
               && (src[pos] == 'h' || src[pos] == 'H')
               && (src[pos + 1] == 't' || src[pos + 1] == 'T')
               && (src[pos + 2] == 't' || src[pos + 2] == 'T')
               && (src[pos + 3] == 'p' || src[pos + 3] == 'P')
               && src[pos + 4] == ':'
               && src[pos + 5] == '/'
               && src[pos + 6] == '/')
                set<skip>(static_cast<int>(pos), 6, elist, params, inSrc);
            else if(pos + 7 < src.size()
                    && (src[pos] == 'h' || src[pos] == 'H')
                    && (src[pos + 1] == 't' || src[pos + 1] == 'T')
                    && (src[pos + 2] == 't' || src[pos + 2] == 'T')
                    && (src[pos + 3] == 'p' || src[pos + 3] == 'P')
                    && (src[pos + 4] == 's' || src[pos + 4] == 'S')
                    && src[pos + 5] == ':'
                    && src[pos + 6] == '/'
                    && src[pos + 7] == '/')
                set<skip>(static_cast<int>(pos), 7, elist, params, inSrc);
            else if(pos + 5 < src.size()
                    && (src[pos] == 'f' || src[pos] == 'F')
                    && (src[pos + 1] == 't' || src[pos + 1] == 'T')
                    && (src[pos + 2] == 'p' || src[pos + 2] == 'P')
                    && src[pos + 3] == ':'
                    && src[pos + 4] == '/'
                    && src[pos + 5] == '/')
                set<skip>(static_cast<int>(pos), 5, elist, params, inSrc);
            else if(pos + 6 < src.size()
                    && (src[pos] == 'f' || src[pos] == 'F')
                    && (src[pos + 1] == 'i' || src[pos + 1] == 'I')
                    && (src[pos + 2] == 'l' || src[pos + 2] == 'L')
                    && (src[pos + 3] == 'e' || src[pos + 3] == 'E')
                    && src[pos + 4] == ':'
                    && src[pos + 5] == '/'
                    && src[pos + 6] == '/')
                set<skip>(static_cast<int>(pos), 6, elist, params, inSrc);
            else if(pos + 6 < src.size()
                    && (src[pos] == 'm' || src[pos] == 'M')
                    && (src[pos + 1] == 'a' || src[pos + 1] == 'A')
                    && (src[pos + 2] == 'i' || src[pos + 2] == 'I')
                    && (src[pos + 3] == 'l' || src[pos + 3] == 'L')
                    && (src[pos + 4] == 't' || src[pos + 4] == 'T')
                    && (src[pos + 5] == 'o' || src[pos + 5] == 'O')
                    && src[pos + 6] == ':')
                set<skip>(static_cast<int>(pos), 6, elist, params, inSrc);
            else if(pos + 8 < src.size()
                    && (src[pos] == 'c' || src[pos] == 'C')
                    && (src[pos + 1] == 'o' || src[pos + 1] == 'O')
                    && (src[pos + 2] == 'n' || src[pos + 2] == 'N')
                    && (src[pos + 3] == 'f' || src[pos + 3] == 'F')
                    && src[pos + 4] == ':'
                    && (src[pos + 5] == 's' || src[pos + 5] == 'S')
                    && (src[pos + 6] == 'i' || src[pos + 6] == 'I')
                    && (src[pos + 7] == 'p' || src[pos + 7] == 'P')
                    && src[pos + 8] == ':')
                set<skip>(static_cast<int>(pos), 8, elist, params, inSrc);
            else if(pos + 8 < src.size()
                    && (src[pos] == 'm' || src[pos] == 'M')
                    && (src[pos + 1] == 'e' || src[pos + 1] == 'E')
                    && (src[pos + 2] == 'e' || src[pos + 2] == 'E')
                    && (src[pos + 3] == 't' || src[pos + 3] == 'T')
                    && src[pos + 4] == ':'
                    && (src[pos + 5] == 's' || src[pos + 5] == 'S')
                    && (src[pos + 6] == 'i' || src[pos + 6] == 'I')
                    && (src[pos + 7] == 'p' || src[pos + 7] == 'P')
                    && src[pos + 8] == ':')
                set<skip>(static_cast<int>(pos), 8, elist, params, inSrc);
            else if(pos + 3 < src.size()
                    && (src[pos] == 'w' || src[pos] == 'W')
                    && (src[pos + 1] == 'w' || src[pos + 1] == 'W')
                    && (src[pos + 2] == 'w' || src[pos + 2] == 'W')
                    && (pos == 0 || (src[pos - 1] != '/'
                                     && (src[pos - 1] < 'a' || src[pos - 1] > 'z')
                                     && (src[pos - 1] < 'A' || src[pos - 1] > 'Z')
                                     && (src[pos - 1] < '0' || src[pos - 1] > '9'))))
                set<skip>(static_cast<int>(pos), 2, elist, params, inSrc);
        }



        void skip::run(const string& /*src*/, size_t /*pos*/) {
            if(!--count)
                set<check>(begin, elist, params, inSrc);
        }

        void skipSrc::run(const string& /*src*/, size_t /*pos*/) {
            if(!--count)
                set<start>(elist, params, true);
        }

        bool check::forbidden(const string& src, size_t pos) {
            return (pos + 3 < src.size()
                    && src[pos] == '&'
                    && (src[pos + 1] == 'g' || src[pos + 1] == 'G')
                    && (src[pos + 2] == 't' || src[pos + 2] == 'T')
                    && src[pos + 3] == ';')
                || (pos + 3 < src.size()
                    && src[pos] == '&'
                    && (src[pos + 1] == 'l' || src[pos + 1] == 'L')
                    && (src[pos + 2] == 't' || src[pos + 2] == 'T')
                    && src[pos + 3] == ';')
                || (pos + 5 < src.size()
                    && src[pos] == '&'
                    && (src[pos + 1] == 'n' || src[pos + 1] == 'N')
                    && (src[pos + 2] == 'b' || src[pos + 2] == 'B')
                    && (src[pos + 3] == 's' || src[pos + 3] == 'S')
                    && (src[pos + 4] == 'p' || src[pos + 4] == 'P')
                    && src[pos + 5] == ';')
                || (pos + 1 < src.size()
                    && src[pos] == '\xC2' && src[pos + 1] == '\xA0') // utf 2-byte nbsp equivalent, f*ck sanitizer!
                || (pos + 7 < src.size()
                    && src[pos] == '&'
                    && src[pos + 1] == '#'
                    && src[pos + 2] == 'x'
                    && std::all_of(&src[pos + 3], &src[pos + 6], [](unsigned char c) { return std::isxdigit(static_cast<int>(c)); })
                    && src[pos + 7] == ';')
                || (src[pos] >= 0 && src[pos] <= 32)|| src[pos] == '\"' || src[pos] == '<'
                || src[pos] == '>' || src[pos] == '\\' || src[pos] == '^'
                || src[pos] == '`' || src[pos] == '{' || src[pos] == '|'
                || src[pos] == '}';
        }

        bool check::punctuation(char c) {
            return c == '!' || c == '?' || c == '.' || c == ',' || c == ';' || c == ':';
        }

        bool check::amp(const string& str, int pos)
        {
            return pos-4>=0
               &&  str[pos-4] == '&'
               && (str[pos-3] == 'a' || str[pos-3] == 'A')
               && (str[pos-2] == 'm' || str[pos-2] == 'M')
               && (str[pos-1] == 'p' || str[pos-1] == 'P')
               &&  str[pos] == ';';
        }

        bool check::in_parens(const string& src, size_t pos, int index) {
            static char open[2] = {'(', '['};
            static char close[2] = {')', ']'};
            return begin && src[pos - 1] == close[index]
                && (count[index] || src[begin - 1] == open[index]);
        }

        void check::run(const string& src, size_t pos)  {
            if(pos >= src.size() || forbidden(src, pos)) {
                if(dotpos && pos - dotpos >= 3) {
                    if(punctuation(src[pos - 1]) && !amp(src, static_cast<int>(pos-1))) pos--;
                    if(in_parens(src, pos, 0)) pos--;
                    else if(in_parens(src, pos, 1)) pos--;
                    if( extractMode() ) {
                    push(0, begin, static_cast<int>(pos), (inSrc ? "src=" : ""), "");
                    set<start>(elist, params,false);
                    return;
                    }
                    msg_body::ExtVideoSingleton extVideo;
                    msg_body::EmbedInfo emb;
                    string url = src.substr(begin, pos - begin);
                    if(extVideo.instance().checkUrl(url, emb)) {
                        emb.id = static_cast<int>(elist->size());
                        elist->push_back(emb);
                        push(0, begin, static_cast<int>(pos), "<span class=\"wmi-video-link\" "
                             "title=\"" + boost::lexical_cast<string>(emb.id) + "\">",
                             "</span>");
                    } else if((src[begin] == 'm' || src[begin] == 'M')
                              && (src[begin + 1] == 'a' ||src[begin + 1] == 'A')
                              && (src[begin + 2] == 'i' ||src[begin + 2] == 'I')
                              && (src[begin + 3] == 'l' ||src[begin + 3] == 'L')
                              && (src[begin + 4] == 't' ||src[begin + 4] == 'T')
                              && (src[begin + 5] == 'o' ||src[begin + 5] == 'O')
                              && src[begin + 6] == ':') {
                        push(0, begin + 7, static_cast<int>(pos),
                             "<span class=\"wmi-mailto\">", "</span>");
                    } else {
                        std::string wrappedUrl = params.vdirect->process(src.substr(begin, pos-begin));
                        push(0, begin, static_cast<int>(pos), "<span class=\"wmi-link\" show=\"", "\">" + wrappedUrl + "</span>");
                    }
                }
                set<start>(elist, params, false);
            } else if(src[pos] == '(') count[0]++;
            else if(src[pos] == ')') count[0]--;
            else if(src[pos] == '[') count[1]++;
            else if(src[pos] == ']') count[1]--;
            else if(src[pos] == '.' && !dotpos) dotpos = static_cast<int>(pos);
        }



    }

    namespace url {
        driver::driver(list<overlay>& r, msg_body::EmbedInfos& el, const Params& params, bool e)
            : hiliter::driver(0, "<span class=\"wmi-link\">", "</span>", r, e)  {
            set(new start(*this, &el, params, false));
        }
    }
}

#ifdef __clang__
#pragma clang diagnostic pop
#endif
