#include <string>
#include <list>
#include <internal/hilight/hilight.h>

namespace hiliter {

    void driver::set(state *ns) {
        previousStates.push_back( std::move(s) );
        s.reset( ns );
    }

    void driver::run(const string& src, size_t pos) {
        if(s) s->run(src, pos);
        previousStates.clear();
    }

    void driver::push(int p, int begin, int end,
                      const string& pp, const string& ss) {
        overlay n(begin, end, p, pp, ss);
        list<overlay>::iterator i = res.end(), k = res.end();
        while(i != res.begin()) {
            list<overlay>::iterator j = i;
            overlay& o = *(--i);
            if(begin >= o.end)      res.insert(res.erase(j, k), n);
            else if(end < o.begin) { --k; continue; }
            else if(p < o.prio) {
                if(begin < o.begin) continue;
                else res.insert(res.erase(i, k), n);
            }
            return;
        }
        res.insert(res.erase(i, k), n);
    }

    void driver::push(int p, int begin, int end) {
        push(p, begin, end, prefix, suffix);
    }

    void driver::push(int begin, int end) {
        push(prio, begin, end, prefix, suffix);
    }



    string hilite(const string& src, msg_body::EmbedInfos& el, const Params& params) {
        std::list<hiliter::overlay> res;
        hiliter::url::driver drv(res, el, params, false);
        hiliter::email::driver drv2(res);
        hiliter::phone::driver drv3(res);
        hiliter::tag::driver drv4(res);
        for(size_t i = 0; i <= src.size(); ++i) {
            drv.run(src, i);
            drv2.run(src, i);
            drv3.run(src, i);
            drv4.run(src, i);
        }
        size_t pos = 0;
        std::string result = "";
        while(!res.empty()) {
            result += res.front().accumulate(src, pos, params);
            res.pop_front();
        }
        result += src.substr(pos);
        return result;
    }
}
