#include <internal/hilight/hilight.h>

namespace hiliter {
    namespace {
        struct start: public state {
            start(hiliter::driver& drv): state(drv) {}
            void run(const string& src, size_t pos) override;
        };



        struct country: public state {
            country(hiliter::driver& drv, int b)
                : state(drv), begin(b), n(0), last(0) {}
            void run(const string& src, size_t pos) override;

        private:
            int begin, n, last;
        };



        struct area: public state {
            area(hiliter::driver& drv, int b, int num)
                : state(drv), begin(b), n(num) {}
            void run(const string& src, size_t pos) override;

        private:
            int begin, n;
        };



        struct number: public state {
            number(hiliter::driver& drv, int b, int num)
                : state(drv), begin(b), n(num), last(0) {}
            void run(const string& src, size_t pos) override;

        private:
            int begin, n, last;
        };





        bool numchar(char c) {
            return c >= '0' && c <= '9';
        }


        bool phonespace(char c, char p) {
            return c == ' ' || (c == '-' && p != '-');
        }



        void start::run(const string& src, size_t pos) {
            if(pos < src.size()) {
                if(src[pos] == '+')
                    set<country>(static_cast<int>(pos));
                else if(src[pos] == '(')
                    set<area>(static_cast<int>(pos), 0);
                else if(numchar(src[pos]))
                    set<number>(static_cast<int>(pos), 1);
            }
        }



        void country::run(const string& src, size_t pos) {
            if(pos >= src.size()) {
                if(last && n >= 7) push(begin, last + 1);
                set<start>();
            } else if(src[pos] == '(') {
                if(n == 0) set<start>();
                else set<area>(begin, n);
            } else if(numchar(src[pos])) {
                ++n;
                last = static_cast<int>(pos);
            } else if(!phonespace(src[pos], src[pos - 1])) {
                if(last && n >= 7) push(begin, last + 1);
                set<start>();
            }
        }



        void area::run(const string& src, size_t pos) {
            if(pos < src.size()) {
                if(numchar(src[pos])) ++n;
                else if(src[pos] == ')') {
                    if(n >= 3) set<number>(begin, n);
                    else set<start>();
                } else if(!phonespace(src[pos], src[pos - 1]))
                    set<start>();
            }
        }



        void number::run(const string& src, size_t pos) {
            if(pos >= src.size()) {
                if(last && n >= 7) push(begin, last + 1);
                set<start>();
            } else if(numchar(src[pos])) {
                ++n;
                last = static_cast<int>(pos);
            } else if(!phonespace(src[pos], src[pos - 1])) {
                if(last && n >= 7) push(begin, last + 1);
                set<start>();
            }
        }
    }

    namespace phone {
        driver::driver(list<overlay>& r)
            : hiliter::driver(2, "<span class=\"wmi-callto\">", "</span>", r) {
            set(new start(*this));
        }
    }
}
