#include <set>
#include <internal/hilight/hilight.h>

namespace hiliter {
    namespace {
        struct start: public state {
            start(hiliter::driver& d, int s = -1, const string& eT = ""): state(d), bskip(s), exceptionTag(eT) {}
            void run(const string& src, size_t pos) override;

        private:
            int bskip;
            string exceptionTag;
        };



        struct space1: public state {
            space1(hiliter::driver& d, int b, int s, const string& eT)
                : state(d), begin(b), bskip(s), exceptionTag(eT) {}
            void run(const string& src, size_t pos) override;

        private:
            int begin, bskip;
            string name;
            string exceptionTag;
        };

        //links in theese tags are not suposed to be hilighted
        typedef std::set<string> TagExceptions;
        const string tagExceptionsArr[]= {"a", "pre", "code", "textarea", "samp", "var", "kbd", "map"};
        const TagExceptions tagExceptions(tagExceptionsArr, tagExceptionsArr+8);

        struct tagname: public state {
            tagname(hiliter::driver& d, int b, const string& n, int s, const string& eT)
                : state(d), begin(b), bskip(s), name(n), exceptionTag(eT) {}
            void run(const string& src, size_t pos) override;

        private:
            int begin, bskip;
            string name;
            string exceptionTag; //current exception tag
        };



        struct skip: public state {
            skip(hiliter::driver& d, int b, int s, const string& eT)
                : state(d), begin(b), bskip(s), exceptionTag(eT) {}
            void run(const string& src, size_t pos) override;

        private:
            int begin, bskip;
            string exceptionTag;
        };



        struct skip2: public state {
            skip2(hiliter::driver& d, int, int s, const string& eT)
                : state(d), bskip(s), exceptionTag(eT) {}
            void run(const string& src, size_t pos) override;

        private:
            int bskip;
            string exceptionTag;
        };



        void start::run(const string& src, size_t pos) {
            if(pos < src.size() && src[pos] == '<') set<space1>(static_cast<int>(pos), bskip, exceptionTag);
        }



        void space1::run(const string& src, size_t pos) {
            if(pos >= src.size() || src[pos] == '>') {
                push(begin, static_cast<int>(pos));
                set<start>(bskip, exceptionTag);
            } else if(src[pos] == '/') {
                name = "/";
            } else if(src[pos] != ' ') {
                name += src[pos];
                set<tagname>(begin, name, bskip, exceptionTag);
            }
        }



        void tagname::run(const string& src, size_t pos) {
            if(pos >= src.size() || src[pos] == '>') {
                push(begin, static_cast<int>(pos));
                TagExceptions::const_iterator it = tagExceptions.find(name);
                if(it != tagExceptions.end() && exceptionTag == "") {
                    set<start>(begin, *it);
                } else if((name == "/a" || name == "/map") && bskip >= 0) {
                    push(PRIO_VDIRECT, bskip, static_cast<int>(pos));
                    set<start>(-1, "");
                } else if(name == "/"+exceptionTag && bskip >= 0) {
                    push(-2, bskip, static_cast<int>(pos));
                    set<start>(-1, "");
                } else set<start>(bskip, exceptionTag);
            } else if(src[pos] == ' ') {
                TagExceptions::const_iterator it = tagExceptions.find(name);
                if(it != tagExceptions.end() && exceptionTag == "") {
                    set<skip>(begin, begin, *it);
                } else if(name == "/"+exceptionTag && bskip >= 0) {
                    set<skip2>(bskip, bskip, "");
                } else {
                    set<skip>(begin, bskip, exceptionTag);
                }
            } else name += src[pos];
        }



        void skip::run(const string& src, size_t pos) {
            if(pos >= src.size() || src[pos] == '>') {
                push(begin, static_cast<int>(pos));
                set<start>(bskip, exceptionTag);
            }
        }



        void skip2::run(const string& src, size_t pos) {
            if(pos >= src.size() || src[pos] == '>') {
                push(-2, bskip, static_cast<int>(pos));
                set<start>(-1, exceptionTag);
            }
        }
    }

    namespace tag {
        driver::driver(list<overlay>& r)
            : hiliter::driver(-1, "", "", r)  {
            set(new start(*this));
        }
    }
}
