#include <internal/macs/factory.h>

namespace msg_body {

AsyncMacsServicePtr getAsyncMacsService(const ymod_maildb::Module& maildb, MacsParams params, JournalParams ujParams,
                                         const LogPtr& logger, YieldCtx yc) {
    if (params.uid.empty()) {
        throw std::invalid_argument("getAsyncMacsService: need uid");
    }
    return std::make_shared<AsyncMacsService>(maildb, std::move(params), std::move(ujParams), logger, std::move(yc));
}

}
