#include <boost/regex.hpp>
#include <internal/mail_quote/tokenizer.h>

namespace msg_body {
namespace mail_quote {

TokenSequence tokenize(const std::string& content) {
    static const boost::regex regex(R"(^-- ?\r?\n|\r\n|[^&<>\r\n\t ]+|.)");
    TokenSequence tokens;
    const auto begin = boost::sregex_token_iterator(content.begin(), content.end(), regex);
    const auto end = boost::sregex_token_iterator();
    for (auto it = begin; it != end; ++it) {
        tokens.push_back(Token(*it));
    }
    return tokens;
}

} // namespace mail_quote
} // namespace msg_body
