#include <internal/message_source.h>
#include <mail_getter/MessageAccess.h>
#include <internal/server/request_context.h>
#include <internal/config.h>
#include <internal/macs/factory.h>
#include <internal/mulcagate/logging.h>

namespace msg_body {

MessageSourceParams parseMessageSourceParams(const RequestContext& req) {
    MessageSourceParams res;
    res.mid = req.getRequiredNonEmptyArg("mid");
    res.uid = req.getRequiredNonEmptyArg("uid");
    res.requestId = req.requestId();
    return res;
}


MacsParams getMacsParams(const MessageSourceParams& params) {
    MacsParams res;
    res.uid = params.uid;
    res.requestId = params.requestId;
    return res;
}

std::string getCharset(MessageAccessPtr& messageAccess) {
    std::deque<std::string> levelsQueue {rootHid};

    while (!levelsQueue.empty()) {
        const auto hid = levelsQueue.front();
        levelsQueue.pop_front();

        const auto hs = messageAccess->getHeaderStruct(hid);
        if (hs.contentType() == "text" && !hs.charset().empty()) {
            return hs.charset();
        }

        auto metaLevel = messageAccess->getBodyStruct(hid);
        std::move(metaLevel.begin(), metaLevel.end(), std::back_inserter(levelsQueue));
    }

    return "";
}

MessageSource getMessageSource(const Configuration& config, const MessageSourceParams& params, LogPtr logger, YieldCtx yc) {
    const PaLog paLog(__FUNCTION__, params.requestId);
    const auto asyncMacsService = getAsyncMacsService(*config.maildb, getMacsParams(params), JournalParams{}, logger, yc);
    const auto mgLogger = MulcagateLog::create(params.requestId);
    const auto storageService = config.mailStorage->createService(mgLogger, params.ticket, params.requestId);
    auto messageAccess = storageService->createMessageAccess(
            mail_getter::getMessageAccessParams(*asyncMacsService, params.mid), *config.recognizer, yc);
    const auto result = MessageSource {getCharset(messageAccess), encode_base64(messageAccess->getWhole())};
    paLog.write();
    return result;
}

}
