
#include <internal/phishing.h>
#include <fstream>

namespace msg_body {

PhishingChecker PhishingSingleton::_instance;

bool PhishingChecker::check(const std::string& text, std::string& matched)
{
    std::string why;
    if(NULL!=wm.get() && wm->Search(text, why)) {
        matched = "pattern: " + why;
        return true;
    } else if(search(text, why)) {
        matched = "regexp: " + why;
        return true;
    }
    return false;
}

void PhishingChecker::loadPatternFrom(const std::string& file)
{
    if (NULL==wm.get()) {
        wm.reset(new WuManber());
    }
    wm->loadPatternsFromFile(file);
}

}
