#include <boost/range/algorithm/find_if.hpp>

#include <internal/pa_log.h>
#include <yplatform/util.h>
#include <butil/http/codes.h>
#include <internal/sanitizer.h>

namespace msg_body {

std::string Sanitizer::getSanitizeMethod(
        const SanitizerParams& params,
        bool isSecure,
        bool isSpam) const {
    if (isSpam) {
        return params.methodSpam;
    } else if (isSecure) {
        return params.methodHttps;
    } else {
        return params.methodHttp;
    }
}

Sanitizer::Sanitizer(const SanitizerParams& params, bool isSecure, bool isSpam,
                     const std::string& requestId, const http::headers& headersToPass,
                     GetServiceTicket&& getServiceTicket, YieldCtx yc, const GetClusterClient& getClusterClient)
    : params_(params)
    , isSecure_(isSecure)
    , isSpam_(isSpam)
    , requestId_(requestId)
    , headersToPass_(headersToPass)
    , yc_(yc)
    , getServiceTicket_(std::move(getServiceTicket))
    , getClusterClient_(getClusterClient)
{}

std::string getHeaderI(const std::string& name, const ymod_httpclient::headers_dict &headers) {
    const auto it = std::find_if(headers.begin(), headers.end(),
            [&name](const auto& hdr) {
                return yplatform::util::iequals(name, hdr.first);
            });
    return it != headers.end() ? it->second : "";
}

}
