#include <fstream>
#include <iostream>
#include <sys/stat.h>
#include <internal/search/regular.h>

int Regular::loadRegexp( std::vector<std::string> & lines )
{
  rwLock.lock_write();

  std::ifstream ifs(file.c_str());
  char buf[4096];

  if (!ifs)
  {
   std::cout << __PRETTY_FUNCTION__ << " no such file " << file << std::endl;
   rwLock.unlock();
   return 0;
  }

  while ( ifs.getline( buf , sizeof ( buf ) ) )
  { lines.push_back(buf);  }

  mtime = getFileTimeStamp ();

  rwLock.unlock();

  return 1;
};

int Regular::compileRegexp( std::vector<std::string> & lines )
{
 std::vector<std::string>::iterator itLine;

 rwLock.lock_write();

 freeRegexp();

 for ( itLine = lines.begin(); itLine != lines.end(); itLine++ )
 {

  if ( itLine->empty() ) continue;

  Regexp * exp_st = new Regexp();
  const char* error;
  int error_offset;

  exp_st->orig = *itLine;
  exp_st->exp = pcre_compile ( itLine->c_str(), PCRE_UTF8 | PCRE_CASELESS /* PCRE_MULTILINE */, &error, &error_offset ,  re_table );
  if ( !exp_st->exp )
  {
   std::cout << __PRETTY_FUNCTION__ << " Regexp compile failed " << *itLine << " error " << error << " at " << error_offset << std::endl;
   delete exp_st;
   continue;
  }
  exp_st->extra = pcre_study( exp_st->exp, 0, &error );
  if ( !exp_st->extra && error )
  {
   std::cout << __PRETTY_FUNCTION__ << " Regexp study failed " << *itLine << " error " << error << std::endl;
   delete exp_st;
   continue;
  }
//  std::cout << __PRETTY_FUNCTION__ << " Regexp added " << *itLine << std::endl;
  regexp_vec.push_back( exp_st );
 }

 rwLock.unlock();

 return int(regexp_vec.size());
}



int Regular::initRegexp()
{
 std::vector<std::string> lines;
 if ( loadRegexp ( lines ) )
  if ( compileRegexp ( lines ) > 0 )
   return 1;
 return 0;
};

std::string Regular::getFileTimeStamp ()
{
  struct stat st;
  if ( stat ( file.c_str() , &st ) < 0 )
  {
   std::cout << __PRETTY_FUNCTION__ << " no such file " << file << std::endl;
   return std::string("");
  }
 return std::string( ctime( &(st.st_mtime) ) );
}

bool Regular::checkFileChanged()
{
 return getFileTimeStamp() != mtime;
};


int Regular::search ( const std::string & text, std::string& matched )
{
  if (file.empty())
  {
   std::cout << __PRETTY_FUNCTION__ << " file name empty " << std::endl;
   return 0;
  }
  if (checkFileChanged() && !initRegexp())
  {
   std::cout << __PRETTY_FUNCTION__ << " regexp not initialized " << std::endl;
   return 0;
  }

  return find (text, matched);
};


void Regular::freeRegexp( )
{
 while ( !regexp_vec.empty() )
 {
  Regexp* exp_st = regexp_vec.back();
  delete exp_st;
  regexp_vec.pop_back();
 }
}

void Regular::initRegular( const std::string & filename )
{
 file = filename;
 std::cout << __PRETTY_FUNCTION__ << " phishing file " << filename << std::endl;
}

int Regular::find ( const std::string & text, std::string& matched )
{
  std::vector<Regexp*>::iterator itRegexp;
  bool bMatch = false;

  rwLock.lock_read();

  for ( itRegexp = regexp_vec.begin(); itRegexp != regexp_vec.end(); itRegexp++ )
  {
   int count = pcre_exec( (*itRegexp)->exp, (*itRegexp)->extra, text.c_str(), int(text.size()), 0, PCRE_NOTEMPTY, NULL, 0);
   switch ( count )
   {
    case PCRE_ERROR_NOMATCH: continue;
    case PCRE_ERROR_NULL:
     std::cout << __PRETTY_FUNCTION__ << " got null argument in pcre_exec " << std::endl;
     continue;
    case PCRE_ERROR_BADOPTION:
     std::cout << __PRETTY_FUNCTION__ << " got bad option in pcre_exec " << std::endl;
     continue;
    case PCRE_ERROR_BADMAGIC:
     std::cout << __PRETTY_FUNCTION__ << " got bad regexp meta information in pcre_exec " << std::endl;
     continue;
    case PCRE_ERROR_UNKNOWN_NODE:
     std::cout << __PRETTY_FUNCTION__ << " got unknown node in pcre_exec " << std::endl;
     continue;
    case PCRE_ERROR_NOMEMORY:
     std::cout << __PRETTY_FUNCTION__ << " got no memory in pcre_exec " << std::endl;
     continue;
   }
   if ( count >= 0 )
   {
    bMatch = true;
    matched = (*itRegexp)->orig;
    break;
   }
  }

 rwLock.unlock();

 return bMatch;
}
