#include <mail_getter/alias_class_list.h>
#include <mail_getter/content_type.h>

#include <internal/transformer_attributes.h>
#include <internal/message_context.h>
#include <internal/external_transformers_selector.h>
#include <internal/fact_extractor/parser_config.h>
#include <internal/fact_extractor/async_fact_extractor.h>
#include <internal/transformers/binary_transformer.h>

namespace msg_body {

BinaryTransformer::BinaryTransformer(const TransformerAttributes& attrs,
                                     MessageContext& messageContext,
                                     LogPtr logger,
                                     const IContentTypeDetector& contentTypeDetector,
                                     const AliasClassList& aliasClassList)
    : attrs_(attrs)
    , messageContext_(messageContext)
    , logger_(logger)
    , contentTypeDetector_(contentTypeDetector)
    , aliasClassList_(aliasClassList)
{}

BinaryTransformerResult BinaryTransformer::apply(MessagePart& part) const {
    BinaryTransformerResult res;
    res.isStreamerOn = attrs_.flags.xmlStreamerOn;
    res.isInline = false;
    res.hid = part.hid;
    res.typeInfo = getTypeInfo(part, contentTypeDetector_, aliasClassList_);

    const auto& hs = part.headerStruct;
    const bool isNonemptyCid = !hs.cid().empty();

    if (attrs_.flags.xmlStreamerOn) {
        res.contentType = part.contentType;

        const Cids& cids = messageContext_.cids_;

        const bool isInlineInMime = hs.contentDisposition() == "inline";
        const bool forceInlineForMobile = attrs_.flags.xmlStreamerMobile && isInlineInMime;

        if (isNonemptyCid && (cids.count(hs.cid()) || forceInlineForMobile)) {
            res.isInline = true;
            res.cid = hs.cid();
        }
    } else {
        if (isNonemptyCid) {
            res.isInline = true;
            res.cid = hs.cid();
        }
    }

    const std::string& type = part.contentType.type();
    const std::string& subtype = part.contentType.subtype();
    res.externalTransformersSelector = ExternalTransformersSelector::addExternalTransformersInfo(part.realName, type, subtype);

    return res;
}

}
