
#include <butil/StrUtils/Encoding.h>
#include <internal/transformers/routines.h>
#include <internal/transformers/calendar_transformer.h>

namespace msg_body {

CalendarTransformerResult CalendarTransformer::apply(MessagePart& part) const {
    CalendarTransformerResult res;
    const auto& hs = part.headerStruct;
    Encoding::decode(hs.encoding(), part.content);
    res.contentType = MimeType(hs.contentType(), hs.contentSubtype());
    res.hid = part.hid;
    res.length = estimateSize(hs.length(), hs.encoding());
    return res;
}

}
