#include <mimeparser/rfc2047.h>
#include <macs/mime_part_factory.h>
#include <mail_getter/UTFizer.h>
#include <internal/transformers/message_transformer.h>

namespace msg_body {

MessageTransformer::MessageTransformer(const IContentTypeDetector& contentTypeDetector,
                                       const AliasClassList& aliasClassList,
                                       const Recognizer::Wrapper& recognizer)
    : contentTypeDetector_(contentTypeDetector)
    , aliasClassList_(aliasClassList)
    , recognizer(recognizer)
{}

MessageTransformerResult MessageTransformer::apply(MessagePart& part) const {
    std::string charset;
    std::string subject = mulca_mime::decode_rfc2047(part.messageHeader["subject"], charset);
    utfizeString(recognizer, subject, charset);
    part.headerStruct = macs::MimePartFactory(part.headerStruct).name(subject.empty() ?
            "no_subject" : subject).release();

    MessageTransformerResult res;
    res.hid = part.hid;
    res.bid = part.hid + ".1";
    res.typeInfo = getTypeInfo(part, contentTypeDetector_, aliasClassList_);
    return res;
}

}
