#include <butil/StrUtils/Encoding.h>
#include <internal/message_tree.h>
#include <internal/transformers/pkpass_transformer.h>
#include <internal/transformers/transformers.h>

namespace msg_body {

PkpassTransformer::PkpassTransformer(const std::string& mid, const std::string& from, LogPtr logger,
                                     const Recognizer::Wrapper& recognizer)
    : mid_(mid)
    , from_(from)
    , logger_(logger)
    , recognizer(&recognizer)
{}

PassbookPackage PkpassTransformer::apply(MessagePart& part) const {
    Encoding::decode(part.headerStruct.encoding(), part.content);
    try {
        PassbookPackage res = parsePassbookPackage(*recognizer, part.content);
        MBODY_LOG_INFO(logger_, log::where_name="pkpass", log::mid=mid_, log::message="from=" + from_);
        return res;
    } catch (const PassbookPackageException& e) {
        throw TransformersException("failed to parse pkpass, mid=" + mid_ + ", from=" + from_  + ", error: " + e.what());
    }
}

}
