#include <boost/lexical_cast.hpp>
#include <butil/strtools.h>
#include <internal/transformers/routines.h>

namespace msg_body {

unsigned estimateSize(std::size_t length, const std::string& encoding) {
    const double rawSize = static_cast<double>(length);
    const double adjustedSize = tolow(encoding) == "base64" ? rawSize * 0.75 : rawSize;
    return static_cast<unsigned>(floor(adjustedSize));
}

}
