
#include <butil/butil.h>
#include <mail_getter/vdirect/dummy_vdirect.h>
#include <mail_getter/vdirect/secure_vdirect.h>
#include <internal/server/request_context.h>
#include <internal/config.h>
#include <internal/exceptions.h>
#include <internal/vdirect.h>

namespace msg_body {

VdirectPtr getUidVdirect(const Configuration& config, const VdirectParams& params) {
    const std::string script = config.vdirect.uidScript;
    const SecureVdirect::Params vdirectParams(params.isSecure, params.authDomain, script);
    vdirect::HashProviderPtr hashProvider(new vdirect::UidHashProvider(config.vdirect.keysStorage, params.uid));
    return VdirectPtr(new SecureVdirect(vdirectParams, std::move(hashProvider)));
}

VdirectPtr getSmsVdirect(const Configuration& config, const VdirectParams& params) {
    const SecureVdirect::Params vdirectParams(params.isSecure, params.authDomain, config.vdirect.smsScript);
    vdirect::HashProviderPtr hashProvider(new vdirect::SmsHashProvider(config.vdirect.keysStorage, params.smsSid));
    return VdirectPtr(new SecureVdirect(vdirectParams, std::move(hashProvider)));
}

VdirectPtr getVdirect(const Configuration& config, const VdirectParams& params, bool doWrap) {
    if (!config.vdirect.isConfigured() || !doWrap) {
        return VdirectPtr(new DummyVdirect);
    }
    if (!params.uid.empty()) {
        return getUidVdirect(config, params);
    } else if (!params.smsSid.empty()) {
        return getSmsVdirect(config, params);
    } else {
        throw VdirectException("either uid or sms_sid must not be empty for vdirect");
    }
}

}
