#include <boost/lexical_cast.hpp>
#include <butil/http/arguments.h>
#include <internal/video_links.h>

namespace msg_body {

void addHttpArgIfNotEmpty(HttpArguments& args, const std::string& name, const std::string& value) {
    if (!value.empty()) {
        args.add(name, value);
    }
}

std::string makeParamString(const EmbedInfo& videoLink) {
    HttpArguments args;
    addHttpArgIfNotEmpty(args, "player_url", videoLink.player_url);
    addHttpArgIfNotEmpty(args, "flashvars", videoLink.flashvars);
    addHttpArgIfNotEmpty(args, "height", boost::lexical_cast<std::string>(videoLink.height));
    addHttpArgIfNotEmpty(args, "width", boost::lexical_cast<std::string>(videoLink.width));
    addHttpArgIfNotEmpty(args, "hosting_name", videoLink.hosting_name);
    return args.format();
}

VideoParams getVideoParams(const EmbedInfos& videoLinks) {
    VideoParams res;
    for (EmbedInfos::const_iterator iter = videoLinks.begin(); iter != videoLinks.end(); ++iter) {
        res[iter->id] = makeParamString(*iter);
    }
    return res;
}

}
