#pragma once

#include <util/generic/string.h>
#include <util/stream/output.h>

namespace NMail {

enum EMessageType {
    MT_UNDEFINED = -1 /* "undefined" */,

    // Sender
    MT_S_GROUP_ON_SITE = 14 /* "s_grouponsite" */,
    MT_S_DATING_SITE = 15 /* "s_datingsite" */,
    MT_S_AVIA_ETICKET = 16 /* "s_aviaeticket" */,
    MT_S_BANK = 17 /* "s_bank" */,
    MT_S_SOCIAL = 18 /* "s_social" */,
    MT_S_TRAVEL = 19 /* "s_travel" */,
    MT_S_ZD_TICKET = 20 /* "s_zdticket" */,
    MT_S_REALTY = 21 /* "s_realty" */,
    MT_S_ESHOP = 23 /* "s_eshop" */,
    MT_S_COMPANY = 24 /* "s_company" */,
    MT_S_JOB = 25 /* "s_job" */,
    MT_S_GAME = 26 /* "s_game" */,
    MT_S_TECH = 29 /* "s_tech" */,
    MT_S_MEDIA = 30 /* "s_media" */,
    MT_S_ADVERT = 31 /* "s_advert" */,
    MT_S_PROVIDER = 32 /* "s_provider" */,
    MT_S_FORUM = 33 /* "s_forum" */,
    MT_S_MOBILE = 34 /* "s_mobile" */,
    MT_S_TRAINING = 37 /* "s_training" */,
    MT_S_SENDER = 39 /* "s_sender" */,
    MT_S_TRACKER = 41 /* "s_tracker" */,
    MT_S_TAXI = 43 /* "s_taxi" */,
    MT_S_DELIVERY = 44 /* "s_delivery" */,
    MT_S_STATE = 45 /* "s_state" */,
    MT_S_NEWS = 47 /* "s_news" */,
    MT_S_EVENT = 48 /* "s_event" */,
    MT_S_SEO = 57 /* "s_seo" */,
    MT_S_INSURANCE = 58 /* "s_insurance" */,
    MT_S_YANDEX_PAY = 74 /* "s_yandex_pay" */,

    // Basic
    MT_DELIVERY = 1 /* "delivery" */,
    MT_REGISTRATION = 2 /* "registration" */,
    MT_PEOPLE = 4 /* "people" */,
    MT_ETICKET = 5 /* "eticket" */,
    MT_ESHOP = 6 /* "eshop" */,
    MT_NOTIFICATION = 7 /* "notification" */,
    MT_BOUNCE = 8 /* "bounce" */,
    MT_NEWS = 13 /* "news" */,
    MT_CANCEL = 28 /* "cancel" */,
    MT_HOTEL = 35 /* "hotel" */,
    MT_EDOC = 49 /* "edoc" */,
    MT_REMINDER = 59 /* "reminder" */,
    MT_BOARDING_PASS = 60 /* "boardingpass" */,
    MT_TRACKER_TASK = 61 /* "trackertask" */,
    MT_DISCOUNT = 62 /* "discount" */,
    MT_REMIND_TIC = 63 /* "remind_tic" */,
    MT_TRANSACT = 64 /* "transact" */,
    MT_PERSONAL = 65 /* "personal" */,
    MT_PROMO = 66 /* "promo" */,
    MT_TRIGGER = 67 /* "trigger" */,
    MT_REVIEW = 68 /* "review" */,
    MT_MESSAGE = 69 /* "message" */,
    MT_BILL = 70 /* "bill" */,
    MT_LOST_CART = 71 /* "lostcart" */,
    MT_SMARTREPLY = 72 /* "smartreply" */,
    MT_QUARANTINE = 75 /* "quarantine" */,
    MT_CORRESPOND = 76 /* "correspond" */,

    // Special
    MT_GREETING = 12 /* "greeting" */,
    MT_PERSONAL_NEWS = 22 /* "personalnews" */,
    MT_SCHEMA = 27 /* "schema" */,
    MT_YAMONEY = 36 /* "yamoney" */,
    MT_LIVE_MAIL = 38 /* "livemail" */,
    MT_INVITE = 42 /* "invite" */,
    MT_PHISHING = 40 /* "phishing" */,
    MT_FIRST_MAIL = 46 /* "firstmail" */,
    MT_TRUST_1 = 51 /* "trust_1" */,
    MT_TRUST_2 = 52 /* "trust_2" */,
    MT_TRUST_3 = 53 /* "trust_3" */,
    MT_TRUST_4 = 54 /* "trust_4" */,
    MT_TRUST_5 = 55 /* "trust_5" */,
    MT_TRUST_6 = 56 /* "trust_6" */,
    MT_SO_FP = 73 /* "so_fp" */,
    MT_PF_HAM = 77 /* "pf_ham" */,
    MT_PF_SPAM = 78 /* "pf_spam" */,
    MT_SPF_FAIL = 79 /* "spf_fail" */,
    MT_DKIM_FAIL = 80 /* "dkim_fail" */,
    MT_DMARC_FAIL = 81 /* "dmarc_fail" */,
    MT_IP_RBL = 82 /* "ip_rbl" */,
    MT_URL_RBL = 83 /* "url_rbl" */,
    MT_DNS_FAIL = 84 /* "dns_fail" */,
    MT_RFC_FAIL = 85 /* "rfc_fail" */,

    // Tabs
    MT_T_NEWS = 100 /* "t_news" */,
    MT_T_SOCIAL = 101 /* "t_social" */,
    MT_T_NOTIFICATION = 102 /* "t_notification" */,
    MT_T_PEOPLE = 103 /* "t_people" */,
};

}  // namespace NMail
