#include <mail/message_types/lib/message_types.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/gtest.h>

using namespace NMail;

TEST(MessageTypes, ToString) {
    EXPECT_EQ(ToString(MT_PEOPLE), "people");
    EXPECT_EQ(ToString(MT_QUARANTINE), "quarantine");
}

TEST(MessageTypes, FromString) {
    EXPECT_EQ(FromString<EMessageType>("people"), MT_PEOPLE);
    EXPECT_EQ(FromString<EMessageType>("t_news"), MT_T_NEWS);
    EXPECT_EQ(FromString<EMessageType>("quarantine"), MT_QUARANTINE);
    EXPECT_THROW(FromString<EMessageType>("foo"), yexception);
}

TEST(MessageTypes, TryFromString) {
    EMessageType type = MT_UNDEFINED;
    EXPECT_FALSE(TryFromString<EMessageType>("foo", type));
    EXPECT_EQ(type, MT_UNDEFINED);

    EXPECT_TRUE(TryFromString<EMessageType>("people", type));
    EXPECT_EQ(type, MT_PEOPLE);

    EXPECT_TRUE(TryFromString<EMessageType>("quarantine", type));
    EXPECT_EQ(type, MT_QUARANTINE);
}
