### Описание

Данная библиотека позволяет включить аутентификацию через Blackbox в проектах, реализующих серверную часть приложения на основе движка Micronaut. Т.е. если сервис предполагает обращение к приложению с указанием заголовка **Authorization**, в котором содержится либо **Basic**, либо **OAuth**, то данная библиотека вполне может помочь. Библиотека позволяет использовать для обращения к Blackbox
высокодекларативный реактивный клиент, что должно обеспечивать нормальное поведение при высоких нагрузках.

Давайте рассмотрим, как можно использовать эту библиотеку, на примере application.yml для тестов.

```yaml
micronaut:
  security:
    enabled: true
  http:
    services:
      tvm-tool:
        url: http://localhost:${tvmtool-port}
        health-check: true
        health-check-interval: 1s
        health-check-uri: http://localhost:${tvmtool-port}/tvm/ping
        read-idle-timeout: 1s
        read-timeout: 1s
        connect-timeout: 1s
        num-of-threads: 1
      blackbox:
        url: https://blackbox-test.yandex.net:443
        health-check: true
        health-check-interval: 1s
        health-check-uri: https://blackbox-test.yandex.net:443/ping
        read-idle-timeout: 1s
        read-timeout: 1s
        connect-timeout: 1s
        num-of-threads: 1
blackbox:
  enabled: true
  basic: true
  oauth: true
tvm2:
  token: '01234567890123456789012345678901'
  services:
    blackbox: 224
  allowed-clients:
```

Здесь можно заметить следующие вещи:

* Используется, как несложно заметить, micronaut-security, и его необходимо явно
включить, чтобы начали работать цепочки различных обработчиков.
* Декларативный клиент, который обращается к blackbox, полагается на Service discovery.
Как несложно догадаться, у большинства проектов, гипотетически желающих воспользоваться этой библиотекой,
реального Service discovery не будет на основе Consul, Eureka и т.д. Однако можно указать
вручную, к какому сервису мы обращаемся, а также (при желании) количество повторных попыток,
таймауты и иже с ними.
* Самое главное, это опции самого Blackbox. Прежде всего, чтобы это работало, надо включить blackbox.enabled.
Так сделано для того, чтобы тот, кто просто подключит библиотеку в свой проект, не получил 
при запуске моментально кучу ошибок от того, что он не указал url для blackbox и т.д. Оставшиеся
две опции указывают, что мы желаем использовать в качестве авторизации - либо Basic, либо OAuth.
* Заодно мы стартуем локального tvm демона, генерирующего тикеты для обращения к тестовому паспорту. В качестве мока
паспорт мы не поднимаем, а используем реальный паспорт, который как раз и предназначен для интеграционного
тестирования (но не стрессового, не вздумайте писать стресс тест для проверки обращения к паспорту, 
и если Ваш проект требует стресс тестов, то там как раз нужно отключить обращение
к blackbox, или прописать какой-то мок).
* Насчет tvm. Если планируется прописать в тестах использование клиента для blackbox,
то он подразумевает обращение с tvm. Соответственно, нужно будет в ABC завести
для сервиса ресурс и его id и секрет прописать в tvmtool.conf, как это сделано для
large тестов в данной библиотеке. И да, Ваши тесты тоже должны быть large, 
поскольку они подразумевают поход в тестовый Паспорт. Вам также потребуются гранты 
на этого клиента для обращения к паспорту (это помимо дырки в puncher, само собой) на сетевой
макрос _CMSEARCHNETS_. Для того, чтобы ci аркадии также собирал все корректно,
стоит прописать теги в ya.make типа ya:force_sandbox. Заодно стоит указать, что
Вы предпочитаете использовать ipv6:

> -Djava.net.preferIPv6Addresses=true

Ну и как несложно видеть на примере тестового PingController, по итогам можно получить
ссылку на вполне вменяемый объект:

```java
@Secured(SecurityRule.IS_AUTHENTICATED)
@Get("/auth")
public String auth(BlackboxUid uid) {
    return "auth " + uid;
}
```

Аннотация Nullable нужна в том случае, если предполагается, что авторизации может
и не быть.

Кроме того, интерфейс BlackboxClient автоматом передает в blackbox сведения о ip пользователя,
если они пришли в запросе в заголовке X-Real-Ip. 

**TODO**. Не мешает сделать возможность получения данных о пользователе по его почтовому адресу,
а также передавать доступные почтовые адреса, полученные от blackbox.
