package ru.yandex.mail.micronaut.blackbox;

import java.util.Collections;
import java.util.Map;

import javax.annotation.Nonnull;

import io.micronaut.security.authentication.Authentication;

import static java.util.Collections.singletonMap;

public class BlackboxAuthentication implements Authentication {
    private final Map<String, Object> claims;

    public BlackboxAuthentication(BlackboxResponse response) {
        claims = response.getUid()
            .map(uid -> singletonMap(BlackboxUid.BLACKBOX_KEY, (Object) uid))
            .orElseGet(Collections::emptyMap);
    }

    @Nonnull
    @Override
    public Map<String, Object> getAttributes() {
        return claims;
    }

    @Override
    public String getName() {
        return "blackbox";
    }

    public boolean isAuthenticated() {
        return !claims.isEmpty();
    }

    @Override
    public String toString() {
        return getName() + " " + getAttributes();
    }
}
