package ru.yandex.mail.micronaut.blackbox;

import javax.annotation.Nullable;
import javax.validation.constraints.NotEmpty;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.annotation.Get;
import io.micronaut.http.annotation.QueryValue;
import io.micronaut.http.client.annotation.Client;
import reactor.core.publisher.Mono;

import ru.yandex.mail.micronaut.tvm.auth.TvmSecured;

@TvmSecured
@Client(id = BlackboxClient.CLIENT_ID)
@Requires(property = "blackbox.enabled", value = "true")
public interface BlackboxClient {
    String CLIENT_ID = "blackbox";

    default Mono<BlackboxResponse> login(String login, String userip, String password) {
        return handle(login, userip, password, "login", null);
    }

    default Mono<BlackboxResponse> oauth(String token, String userip) {
        return handle(null, userip, null, "oauth", token);
    }

    @Get("/blackbox?format=json")
    Mono<BlackboxResponse> handle(@QueryValue @Nullable String login, @QueryValue @Nullable String userip,
                                  @QueryValue @Nullable String password, @QueryValue @NotEmpty String method,
                                  @QueryValue("oauth_token") @Nullable String token);
}
