package ru.yandex.mail.micronaut.blackbox;

import javax.inject.Inject;
import javax.inject.Singleton;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.filters.AuthenticationFetcher;
import lombok.extern.slf4j.Slf4j;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

@Slf4j
@Singleton
@Requires(property = "blackbox.oauth")
@Requires(beans = BlackboxClient.class)
public class BlackboxOauthAuthenticationFetcher implements AuthenticationFetcher {
    @Inject
    private BlackboxClient client;
    private final BlackboxAuthenticationFetcher fetcher;

    public BlackboxOauthAuthenticationFetcher() {
        fetcher = new BlackboxAuthenticationFetcher("OAuth ", this::getBlackboxResponse);
    }

    protected Mono<BlackboxResponse> getBlackboxResponse(String token, String userip) {
        return client.oauth(token, userip);
    }

    @Override
    public Publisher<Authentication> fetchAuthentication(HttpRequest<?> request) {
        return fetcher.fetchAuthentication(request);
    }
}
