package ru.yandex.mail.micronaut.blackbox;

import java.util.Optional;

import lombok.Value;
import reactor.core.publisher.Mono;

@Value
public class BlackboxResponse {
    BlackboxStatus status;
    Optional<BlackboxUid> uid;


    public static Mono<BlackboxResponse> failure() {
        return Mono.just(new BlackboxResponse(new BlackboxStatus(BlackboxStatusValue.INTERNAL_FAILURE), Optional.empty()));
    }
}
