package ru.yandex.mail.micronaut.blackbox;

import java.util.Optional;

import javax.inject.Singleton;

import io.micronaut.context.annotation.Requires;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.type.Argument;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.bind.binders.TypedRequestArgumentBinder;
import io.micronaut.security.authentication.Authentication;

@Singleton
@Requires(property = "blackbox.enabled")
public class BlackboxUidBinder implements TypedRequestArgumentBinder<BlackboxUid> {
    private static Optional<BlackboxUid> extract(HttpRequest<?> source) {
        return source.getUserPrincipal(Authentication.class)
                .map(Authentication::getAttributes)
                .flatMap(attributes -> Optional.ofNullable((BlackboxUid) attributes.get(BlackboxUid.BLACKBOX_KEY)));
    }

    @Override
    public Argument<BlackboxUid> argumentType() {
        return Argument.of(BlackboxUid.class);
    }

    private static BindingResult<BlackboxUid> bind(Optional<BlackboxUid> uid) {
        return () -> uid;
    }

    @Override
    public BindingResult<BlackboxUid> bind(ArgumentConversionContext<BlackboxUid> context, HttpRequest<?> source) {
        return bind(extract(source));
    }
}
