JUNIT5()

JDK_VERSION(11)

OWNER(
    g:fininfra
)

IF (SANITIZER_TYPE)
    TAG(ya:not_autocheck)
ENDIF()

TAG(ya:noretries ya:fat ya:force_sandbox ya:sandbox_coverage)

JAVAC_FLAGS(
    -parameters
    -Xlint:unchecked
)

NO_LINT()
REQUIREMENTS(network:full)
SIZE(LARGE)

JAVA_SRCS(SRCDIR ${ARCADIA_ROOT}/mail/micronaut/blackbox/src/test/java **/*)
JAVA_SRCS(RESOURCES SRCDIR ${ARCADIA_ROOT}/mail/micronaut/blackbox/src/test/resources **/*)

INCLUDE(${ARCADIA_ROOT}/mail/micronaut/dependency_versions.inc)
INCLUDE(${ARCADIA_ROOT}/mail/micronaut/test_deps.inc)

JVM_ARGS(
    -Djava.net.preferIPv6Addresses=true
)

PEERDIR(
    mail/micronaut/blackbox
    mail/java/tvmlocal/junit_jupiter

    contrib/java/io/micronaut/test/micronaut-test-junit5
    contrib/java/io/micronaut/micronaut-http
    contrib/java/io/micronaut/micronaut-http-server
    contrib/java/io/micronaut/micronaut-http-server-netty
    contrib/java/io/micronaut/micronaut-http-netty

    contrib/java/com/fasterxml/jackson/core/jackson-databind
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jdk8
    contrib/java/com/fasterxml/jackson/module/jackson-module-parameter-names
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jsr310

    contrib/java/one/util/streamex
)

ANNOTATION_PROCESSOR(
    lombok.launch.AnnotationProcessorHider$AnnotationProcessor
    io.micronaut.annotation.processing.TypeElementVisitorProcessor
    io.micronaut.annotation.processing.PackageConfigurationInjectProcessor
    io.micronaut.annotation.processing.BeanDefinitionInjectProcessor
)

END()
